#include "lib.h"
#include "md5.h"

const char *testpairs[] = {
  "",
  "d41d8cd98f00b204e9800998ecf8427e",
  "T",
  "b9ece18c950afbfa6b0fdbfa4ff731d3",
  "Th",
  "eeeb9a8eb45dd351d9ec0eb4acce66ce",
  "The",
  "a4704fd35f0308287f2937ba3eccf5fe",
  "The ",
  "02edd93949f6d3c57d9822691b59f649",
  "The q",
  "6131a51747610d0ae4e86c3a3416788c",
  "The qu",
  "8c871099d54c09d4099fa7a0e77c9113",
  "The qui",
  "bbb9873bad399cd1cc0d5e336ca5beee",
  "The quic",
  "b9b926544b8ecd5c3ef553a87170b726",
  "The quick",
  "912d57cea222bc1730dd531b9d6afbb6",
  "The quick ",
  "03c729679ca3252a4735c4148b7c11e3",
  "The quick b",
  "d7027ce01f22eb9d2bb32d9a153a7e29",
  "The quick br",
  "e05e6a516c92259691cf9194dfdeff92",
  "The quick bro",
  "dd1ac3c70b6f51dd545cdf64053209d4",
  "The quick brow",
  "caa1e1e79c65480a48cf08a38ac1d87d",
  "The quick brown",
  "5aa207e85988921b8733912c4f526c80",
  "The quick brown ",
  "b0e45b65d9e1d88169c40dc47605e2d9",
  "The quick brown f",
  "e4b6d6fabe9dfcbe83a51d19df5f0ac3",
  "The quick brown fo",
  "168534eca593b6cef86aea9081f0f5bf",
  "The quick brown fox",
  "a2004f37730b9445670a738fa0fc9ee5",
  "The quick brown fox ",
  "c4314972a672ded8759cafdca9af3238",
  "The quick brown fox j",
  "29dcbbf4add427ccba06d3c37ad44aa9",
  "The quick brown fox ju",
  "d0312d0e9e2d8c063d95a06fbbba9cb1",
  "The quick brown fox jum",
  "770fd972e360cb8538ce6a880741936e",
  "The quick brown fox jump",
  "8e53cb84ef3d981a86fbb69b24827c46",
  "The quick brown fox jumps",
  "83de97cab1f553eb3acc22866a4f6942",
  "The quick brown fox jumps ",
  "a2829f93d701f36d808d0a698dcebf02",
  "The quick brown fox jumps o",
  "efcead92aba26426db84b75413f17c10",
  "The quick brown fox jumps ov",
  "60a0732774106c2348eb576596668eb9",
  "The quick brown fox jumps ove",
  "d44f138aa2f39488c03391771eea258c",
  "The quick brown fox jumps over",
  "f85199fa76594dfb190fab5dfe42a769",
  "The quick brown fox jumps over ",
  "cd4c02f190df2372cb703994dd84e881",
  "The quick brown fox jumps over t",
  "566cb723d4fb7a7dd38163532fe760b7",
  "The quick brown fox jumps over th",
  "4433001bd59da157c18b09f6c10d4163",
  "The quick brown fox jumps over the",
  "b76b517e01f5b708af50af906adb2dac",
  "The quick brown fox jumps over the ",
  "0f611396bcfe9ab7666c45ebd37e59ba",
  "The quick brown fox jumps over the l",
  "4c6606c2117565959048d356c1d7f6cc",
  "The quick brown fox jumps over the la",
  "5f7f3f510b8a8f0a5e1d6193c6c7f3af",
  "The quick brown fox jumps over the laz",
  "542560ce828579cfe777aa165b4d1bed",
  "The quick brown fox jumps over the lazy",
  "171e092149d366acca00d1cd783e61cd",
  "The quick brown fox jumps over the lazy ",
  "4ed8b5a69f7c329f498320947db666f2",
  "The quick brown fox jumps over the lazy d",
  "eb4c251a5abb3c59d306276ba2dc644d",
  "The quick brown fox jumps over the lazy do",
  "2b6e07526e77047d7935681efc3b9f90",
  "The quick brown fox jumps over the lazy dog",
  "9e107d9d372bb6826bd81d3542a419d6",
  "The quick brown fox jumps over the lazy dog.",
  "e4d909c290d0fb1ca068ffaddf22cbd0",
  "The quick brown fox jumps over the lazy dog. ",
  "1c6d98786bea70b9c34ce7f33201120c",
  "The quick brown fox jumps over the lazy dog. T",
  "65ddd1c2fc3e4dfd4fe542b87165cedf",
  "The quick brown fox jumps over the lazy dog. Th",
  "4201abeb6911b3e2ffb31d06b09af97d",
  "The quick brown fox jumps over the lazy dog. The",
  "dc3569f2edadfd3cbbaf1bb12a648e4b",
  "The quick brown fox jumps over the lazy dog. The ",
  "6eecd04cabc9a4f8d933e40eeced5532",
  "The quick brown fox jumps over the lazy dog. The q",
  "766f9f17894f3a0eacef3f84667b55ce",
  "The quick brown fox jumps over the lazy dog. The qu",
  "0c30c95724fff5016e6a1918cb1ca2b3",
  "The quick brown fox jumps over the lazy dog. The qui",
  "4f29855b961a796e8d368d7564ac3a0b",
  "The quick brown fox jumps over the lazy dog. The quic",
  "ce3a1bd17d22ae5b47ed44f091c9f176",
  "The quick brown fox jumps over the lazy dog. The quick",
  "4e0a6194f8f414c28da89440156a9009",
  "The quick brown fox jumps over the lazy dog. The quick ",
  "02d3c665bf9cc21f31651cdc7f2ccdea",
  "The quick brown fox jumps over the lazy dog. The quick b",
  "b35c6984867c4dc932f9d42ba87cc3b5",
  "The quick brown fox jumps over the lazy dog. The quick br",
  "f98b6d7b5b4959d79a2b6b5b26cf9b7a",
  "The quick brown fox jumps over the lazy dog. The quick bro",
  "dac8b3430fe201150242954c6daf8ea7",
  "The quick brown fox jumps over the lazy dog. The quick brow",
  "b8f24ed180755335e8be326e067ca468",
  "The quick brown fox jumps over the lazy dog. The quick brown",
  "e02c7f42bd44e07724e0f71cee642134",
  "The quick brown fox jumps over the lazy dog. The quick brown ",
  "2a0bf92b82f25992c9c417a070a397aa",
  "The quick brown fox jumps over the lazy dog. The quick brown f",
  "8a0c51850f03b4ad80e0851cbbe0fdf4",
  "The quick brown fox jumps over the lazy dog. The quick brown fo",
  "b1b073bd98cf9a2c4046024b0e1b6fce",
  "The quick brown fox jumps over the lazy dog. The quick brown fox",
  "3ec457cb6db1e6bcd662c3f3f4fe630c",
  "The quick brown fox jumps over the lazy dog. The quick brown fox ",
  "b55db249d5c7542264eecb1540835baf",
  "The quick brown fox jumps over the lazy dog. The quick brown fox j",
  "d07f7e87e25107445bc0473419c0fc63",
  "The quick brown fox jumps over the lazy dog. The quick brown fox ju",
  "8b2bfe36e5edfdb822a9d1fce113da81",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jum",
  "89ca1465f682566dd60cfabfa3f11bf6",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jump",
  "f74492f066757975747d63208074b6f3",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps",
  "472743ca68656efc1b22941801d2b3ac",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps ",
  "b86ca5ba3f97561a99898ce9b32bef84",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps o",
  "6a5cdb4e4a0537bc47add6f353f40d03",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps ov",
  "7ddafb434b98bb44260f5370c970fd2f",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps ove",
  "e2979dc7906b441f3dfeda505d001c5d",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over",
  "3f946b37a2e2deec4e592af669c3dc61",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over ",
  "e6e019b6b8df0119334962125e06d842",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over t",
  "9871f053ed93e778d5090e3dc038815d",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over th",
  "fa1f4e6d041152dd28c32ec0ee565c13",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the",
  "195419e61a49df4c10a3f548ccc670b2",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the ",
  "7a430c4e49148f93769297a6dfa0446b",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the l",
  "6a9a844beaf2dba967b5519f5b030ff5",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the la",
  "b745c9f10771719f69f2f244279f8b3f",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the laz",
  "46872c15d6fa266689583f58e33c08ad",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy",
  "59caddaa702704eaec934cf9f0cbd51a",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy ",
  "3dd3ff2d571a54649c1a990ba68b9ef8",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy d",
  "2f9f8e8986602c8035dc6cbe9d1bf0b4",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy do",
  "eb88f590f024cc3e3ddc7dea5b633f32",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog",
  "059587551f430b5b4fe2804c1291c949",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog.",
  "f168d89e05b664041ee6745f050caa4b",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. ",
  "3db4408fe73eb3a3d019013a833c5352",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. T",
  "fb019f3a29510a824744fb681975e0e3",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. Th",
  "3a73a0e3546de61980ffcd6599e2cce2",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The",
  "b1b9bebdc6c4d1bc9ced10a41f047757",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The ",
  "ea097330d1392892abffe9016d5036fb",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The q",
  "0a54a9f5677442446640f97455e845f1",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The qu",
  "8b156455848e5c5b482f3d8770b46a51",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The qui",
  "ff2500f43c2f3cf26a2327a5d4ec2d87",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quic",
  "8b5861337409e038ea5065918df850f3",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick",
  "2fc58fafbfb718e48bcdacdb8474ec0f",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick ",
  "8c8685b559f60724df36d4eeab36ba76",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick b",
  "b9e5b37a6c2fc492b8c38e884ef26715",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick br",
  "932fc0e7fde9e97ecdb1f82a77aaebab",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick bro",
  "b46271fdc7db2df406a8428add977a98",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brow",
  "b749afc6dd7f6b72ad6b9f8e2a11539b",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown",
  "f35e20073a3181fecf18bd814351873f",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown ",
  "00afd21a603dca4797a46abd95e1f176",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown f",
  "92a9cedaa5906c665413f0dd268e1b91",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fo",
  "6ef072127cbfdccf9120c479e6a18b3d",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox",
  "cd84e91cb86d6796a84769af50208048",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox ",
  "fd7029bde3c821d94c0af5ca2721994f",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox j",
  "3c22dc5501f2df92920fed7477d6d6ea",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox ju",
  "b3f71a58d072fcd2a14b3479f9694bb7",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jum",
  "32a821ae25769872d7f15fb686b24257",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jump",
  "c8ce85938d90db1587c3e93bffa6332d",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps",
  "f879a80b636be47979d104c3169e7d50",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps ",
  "2db3bd9a8ad6d7a7f7e42841a341d75e",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps o",
  "b3c49c0b6c311b0f0b08d1f55d35414d",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps ov",
  "ba1000775b5a42c5303c375f1a1713dc",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps ove",
  "a658d486ce1fe4acf615be3bdc9ca3da",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over",
  "a40e012c4c969f40fa07a92cef43cf28",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over ",
  "e18c5bc6c23223261bc10ffaa7ff00b3",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over t",
  "4a56d26e60b253d00cb41fe6233c19fe",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over th",
  "9b7152bc21e2c84cddfca21b4fba2fa6",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the",
  "ff97f7cfb8c6bf0b15e0e7052892d82d",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the ",
  "abbffe88f9a4b6150120f58662a2547e",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the l",
  "ab44c2cdcb452d203b54a27ff998b482",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the la",
  "345c7581b9719ca72e3fc4d1f663f529",
  "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the laz",
  "78e6ccc74d5b610483216ffed1742ba2",
  NULL
};

void Main() {
  Int success = 0;
  Int count = 0;
  for (const char **p = testpairs; *p; p += 2) {
    count++;
    if (MD5::hexdigest(S(p[0]))->eq(p[1]))
      success++;
  }
  Str *report =
    S("MD5 (")->add(S(success))->add("/")->add(S(count))->add(" matches)");
  Check(success == count, report->c_str());
}
